import matplotlib.pyplot as plt
from scipy import stats,interpolate
import numpy as np
from matplotlib.widgets import Cursor

## tableau contenant les abscisses
X = [0,0.01,0.05,0.1,0.5]
## tableau contenant les ordonnées
Y = [316,321,342,373,559]

fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(111)
## on trace le nuage de points
plt.plot( X , Y, 'r+')
## valeurs minimum et maximum sur l'axe des abscisses et des ordonnées
plt.axis([-0.01, 0.55, 300, 570])

## lissage de la courbe à l'aide de polynôme de degré 5
tck,u = interpolate.splprep([X, Y], k=2)
unew = np.arange(0, 1.01, 0.01)
out = interpolate.splev(unew, tck)
plt.plot( out[0] ,out[1], 'b')

ax.set_title('Quantité de lumière en fonction de concentration massique de la solution')


cursor = Cursor(ax, useblit=True, color='red', linewidth=1)
## ouverture de la fenêtre graphique
plt.show()



